﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.UserInterface
{
    public enum WidgetState
    {
        Focus,
        Pressed
    }

    public class UIWidget
    {
        private bool _active = true;
        public bool Active
        {
            get { return _active; }
            set { _active = value; }
        }

        private bool _visible = true;
        public bool Visible
        {
            get { return _visible; }
            set { _visible = value; }
        }

        private Vector2 _position;
        public Vector2 Position
        {
            get { return _position; }
            set { _position = value; }
        }

        private float _scale;
        public float Scale
        {
            get { return _scale; }
            set { _scale = value; }
        }

        private float _rotation;
        public float Rotation
        {
            get { return _rotation; }
            set { _rotation = value; }
        }

        private Rectangle _bounds;
        public Rectangle Bounds
        {
            get { return _bounds; }
            set { _bounds = value; }
        }

        private Vector2 _origin;
        public Vector2 Origin
        {
            get { return _origin; }
            set { _origin = value; }
        }

        private Color _color = Color.Black;
        public Color WidgetColor
        {
            get { return _color; }
            set { _color = value; }
        }

        private int _widgetState;
        public int WidgetState
        {
            get { return _widgetState; }
            set { _widgetState = value; }
        }

        private UI _parentUI;
        public UI ParentUI
        {
            get { return _parentUI; }
            set { _parentUI = value; }
        }

        public WidgetCallback Callback;

        public virtual void OnCallback()
        {
            if (Callback != null)
                Callback(this);
        }

        public virtual void Update(GameTime gameTime)
        {
             
        }

        public virtual void Draw(SpriteBatch spriteBatch)
        {
            
        }
    }
}
